/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers.hammer;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import pro.mikey.justhammers.HammerItems;
import pro.mikey.justhammers.HammerTags;

public class HammerItem
extends DiggerItem {
    private final int depth;
    private final int radius;
    private TagKey<Block> blocks = BlockTags.f_144282_;

    public HammerItem(Tier tier, int radius, int depth, int level) {
        super(1.0f, -2.8f, tier, BlockTags.f_144282_, HammerItems.DEFAULT_PROPERTIES.m_41503_(HammerItem.computeDurability(tier, level)));
        this.depth = depth;
        this.radius = radius;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)new TranslatableComponent("justhammers.tooltip.size", new Object[]{this.radius, this.radius, this.depth}).m_130940_(ChatFormatting.GRAY));
    }

    private static int computeDurability(Tier tier, int level) {
        return (tier.m_6609_() * 2 + 200 * level) * level;
    }

    public float m_8102_(ItemStack itemStack, BlockState blockState) {
        if (itemStack.m_41776_() - itemStack.m_41773_() <= 1) {
            return -1.0f;
        }
        return super.m_8102_(itemStack, blockState);
    }

    public boolean m_8096_(BlockState blockState) {
        return this.actualIsCorrectToolForDrops(blockState);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.actualIsCorrectToolForDrops(state);
    }

    private boolean actualIsCorrectToolForDrops(BlockState state) {
        int i = this.m_43314_().m_6604_();
        if (i < 3 && state.m_204336_(BlockTags.f_144284_)) {
            return false;
        }
        if (i < 2 && state.m_204336_(BlockTags.f_144285_)) {
            return false;
        }
        return (i >= 1 || !state.m_204336_(BlockTags.f_144286_)) && state.m_204336_(this.blocks);
    }

    public boolean m_6813_(ItemStack hammerStack, Level level, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity) {
        if (level.f_46443_ || blockState.m_60800_((BlockGetter)level, blockPos) == 0.0f) {
            return true;
        }
        HitResult pick = livingEntity.m_19907_(20.0, 1.0f, false);
        if (!(pick instanceof BlockHitResult)) {
            return super.m_6813_(hammerStack, level, blockState, blockPos, livingEntity);
        }
        this.findAndBreakNearBlocks(pick, blockPos, hammerStack, level, livingEntity);
        return super.m_6813_(hammerStack, level, blockState, blockPos, livingEntity);
    }

    public void findAndBreakNearBlocks(HitResult pick, BlockPos blockPos, ItemStack hammerStack, Level level, LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        int size = this.radius / 2;
        int offset = size - 1;
        Direction direction = ((BlockHitResult)pick).m_82434_();
        BoundingBox boundingBox = switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> new BoundingBox(blockPos.m_123341_() - size, blockPos.m_123342_() - (direction == Direction.UP ? this.depth - 1 : 0), blockPos.m_123343_() - size, blockPos.m_123341_() + size, blockPos.m_123342_() + (direction == Direction.DOWN ? this.depth - 1 : 0), blockPos.m_123343_() + size);
            case Direction.NORTH, Direction.SOUTH -> new BoundingBox(blockPos.m_123341_() - size, blockPos.m_123342_() - size + offset, blockPos.m_123343_() - (direction == Direction.SOUTH ? this.depth - 1 : 0), blockPos.m_123341_() + size, blockPos.m_123342_() + size + offset, blockPos.m_123343_() + (direction == Direction.NORTH ? this.depth - 1 : 0));
            case Direction.WEST, Direction.EAST -> new BoundingBox(blockPos.m_123341_() - (direction == Direction.EAST ? this.depth - 1 : 0), blockPos.m_123342_() - size + offset, blockPos.m_123343_() - size, blockPos.m_123341_() + (direction == Direction.WEST ? this.depth - 1 : 0), blockPos.m_123342_() + size + offset, blockPos.m_123343_() + size);
        };
        int damage = 0;
        Iterator iterator = BlockPos.m_121919_((BoundingBox)boundingBox).iterator();
        HashSet<BlockPos> removedPos = new HashSet<BlockPos>();
        while (iterator.hasNext()) {
            boolean correctToolForDrops;
            EventResult eventResult;
            BlockPos pos = (BlockPos)iterator.next();
            if (damage >= hammerStack.m_41776_() - hammerStack.m_41773_() - 1) break;
            BlockState targetState = level.m_8055_(pos);
            if (pos == blockPos || removedPos.contains(pos) || !this.canDestroy(targetState, level, pos) || (eventResult = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock(level, pos, targetState, (ServerPlayer)livingEntity, null)).isFalse()) continue;
            removedPos.add(pos);
            level.m_46953_(pos, false, (Entity)livingEntity);
            if (!player.m_7500_() && (correctToolForDrops = hammerStack.m_41735_(targetState))) {
                targetState.m_60612_((ServerLevel)level, pos, hammerStack);
                List drops = Block.m_49874_((BlockState)targetState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)livingEntity, (ItemStack)hammerStack);
                drops.forEach(e -> Block.m_152435_((Level)level, (BlockPos)pos, (Direction)((BlockHitResult)pick).m_82434_(), (ItemStack)e));
            }
            ++damage;
        }
        if (damage != 0 && !player.m_7500_()) {
            hammerStack.m_41622_(damage, livingEntity, livingEntityx -> livingEntityx.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    private boolean canDestroy(BlockState targetState, Level level, BlockPos pos) {
        if (targetState.m_60800_((BlockGetter)level, pos) <= 0.0f) {
            return false;
        }
        if (targetState.m_204336_(HammerTags.HAMMER_NO_SMASHY)) {
            return false;
        }
        return level.m_7702_(pos) == null;
    }
}

